# -*- coding: utf-8 -*-


def is_in_diff(field, diff):
    return any(field in diff[action] for action in ('added', 'changed', 'removed'))


def differ(old, new):
    if old is not None and new is not None and old.id != new.id:
        raise ValueError('Unable to calculate diff: object ids differ')

    old_attributes = old._attributes if old is not None else {}
    new_attributes = new._attributes if new is not None else {}
    return {
        'added': dict(
            (attr_name, value)
            for attr_name, value in new_attributes.items()
            if attr_name not in old_attributes
        ),
        'changed': dict(
            (attr_name, value)
            for attr_name, value in new_attributes.items()
            if attr_name in old_attributes and value != old_attributes[attr_name]
        ),
        'removed': dict(
            (attr_name, None)
            for attr_name in old_attributes
            if attr_name not in new_attributes
        ),
    }
