# -*- coding: utf-8 -*-
from passport.backend.oauth.core.common.errors import BaseError


class AttributeNotFoundError(BaseError):
    """Атрибут с таким ID или именем не существует"""


class BaseDBError(BaseError):
    """Базовая ошибка БД"""
    def __init__(self, *args, **kwargs):
        self.host = kwargs.pop('host', None)
        super(BaseDBError, self).__init__(*args, **kwargs)


class DBTemporaryError(BaseDBError):
    """Временная ошибка БД"""


class DBIntegrityError(BaseDBError):
    """Попытка добавления данных, нарушающих ограничения целостности БД"""


class EntityNotFoundError(Exception):
    """Сущность не найдена"""


class EAVAttributeTypesAlreadyRegisteredError(BaseError):
    """Attribute types уже зарегистрированы"""


class EAVAutoIdAlreadyRegisteredError(BaseError):
    """Auto ID уже зарегистрирован"""
