# -*- coding: utf-8 -*-
from passport.backend.oauth.core.db.eav.errors import EAVAutoIdAlreadyRegisteredError
from sqlalchemy.schema import (
    Column,
    MetaData,
)
from sqlalchemy.types import (
    BigInteger,
    Integer,
    SmallInteger,
    VARBINARY,
)


def eav_columns(id_type=BigInteger):
    return (
        Column('id', id_type, primary_key=True, autoincrement=False, nullable=False),
        Column('type', SmallInteger, primary_key=True, autoincrement=False, nullable=False),
        Column('value', VARBINARY(65523), nullable=False),
    )


def auto_id_columns():
    # SQLite не умеет autoincrement с BigInteger :(
    return (
        Column('id', Integer, primary_key=True, autoincrement=True),
    )


central_metadata = MetaData()
shard_metadata = MetaData()


auto_id = {}  # заполняется через register_auto_id


def register_auto_id(name, table):
    if name in auto_id:
        raise EAVAutoIdAlreadyRegisteredError()  # noqa
    auto_id[name] = table
