# -*- coding: utf-8 -*-
from passport.backend.oauth.core.db.eav.query_base import BaseExecutable


class Transaction(BaseExecutable):
    """Транзакция. Содержит в себе несколько запросов (с типом, унаследованным от BaseQuery),
    относящихся к одной и той же БД."""
    def __init__(self, queries=None, callback=None):
        super(Transaction, self).__init__()
        self._queries = []
        self._dbm = None
        self._callback = callback or (lambda x: x)
        for query in (queries or []):
            self.add(query)

    def __repr__(self):
        return '<Transaction>: %d queries' % len(self._queries)

    def add(self, query):
        """Добавляет к транзакции ещё один запрос"""
        if self.dbm is not None and query.dbm != self.dbm:
            raise ValueError('Unable to add query for other DB: %s != %s' % (query.dbm, self._dbm))
        self._queries.append(query)
        self._dbm = query.dbm

    @property
    def dbm(self):
        return self._dbm

    @property
    def queries(self):
        return self._queries

    def _execute(self):
        if not self.queries:
            return
        results = self.dbm.transaction(self)
        return self._callback(results)

    @property
    def is_selectable(self):
        return all(query.to_sql().is_selectable for query in self.queries)
