# -*- coding: utf-8 -*-
from time import time


DB_NULL = '-'


class Event(object):
    """Событие (для клиента). Представляет пару (время, тип_события)"""
    def __init__(self, type, timestamp=None):
        self.timestamp = round(timestamp or time())
        self.type = type

    @classmethod
    def parse(cls, serialized_value):
        ts, type_ = serialized_value.split(b',', 1)
        return cls(type=int(type_), timestamp=int(ts))

    def serialize(self):
        return '%d,%d' % (self.timestamp, self.type)

    def __lt__(self, other):
        return (self.timestamp, self.type) < (other.timestamp, other.type)

    def __repr__(self):
        return self.serialize()
