# -*- coding: utf-8 -*-
import warnings

from sqlalchemy.exc import SAWarning
from sqlalchemy.ext.compiler import compiles
from sqlalchemy.sql import Insert


@compiles(Insert)
def oauth_sqlalchemy_ext(insert, compiler, **kw):
    s = compiler.visit_insert(insert, **kw)

    if 'on_duplicate_update_keys' in insert.kwargs:
        keys = insert.kwargs['on_duplicate_update_keys']
        if compiler.dialect.name == 'mysql':
            values = ', '.join('%s = VALUES(%s)' % (key, key) for key in sorted(keys))  # pragma: no cover
            tail = 'ON DUPLICATE KEY UPDATE %s' % values                                # pragma: no cover
            s += ' ' + tail                                                             # pragma: no cover
        elif compiler.dialect.name == 'sqlite':
            s = s.replace('INSERT', 'INSERT OR REPLACE', 1)

    return s


def insert_on_duplicate_update(table, keys_to_update):
    with warnings.catch_warnings():
        # Фильтруем ворнинг о неизвестном аргументе 'on_duplicate_update_keys'
        warnings.filterwarnings('ignore', category=SAWarning)
        return table.insert(on_duplicate_update_keys=keys_to_update)
