# -*- coding: utf-8 -*-
from passport.backend.oauth.core.common.errors import BaseError
from passport.backend.oauth.core.db.eav import EntityNotFoundError


class PaymentAuthNotPassedError(BaseError):
    """Запрошенный набор скоупов требует прохождения платёжной авторизации, но она не была пройдена"""


class ExpiredRequestError(EntityNotFoundError):
    """Срок действия запроса на получение токена истёк"""


class VerificationCodeCollisionError(BaseError):
    """Не удалось сгенерировать код подтверждения"""


class WrongRequestUserError(BaseError):
    """Запрос на получение токена создан другим пользователем"""


class TokenLimitExceededError(BaseError):
    """Для данного приложения и уида выдано слишком много токенов, не удаётся выдать ещё один"""


class PsuidInvalidError(BaseError):
    """Невозможно распарсить переданную строку как PSUID"""
