# -*- coding: utf-8 -*-
from passport.backend.oauth.core.common.utils import now
from passport.backend.oauth.core.db.eav import EavAttr
from passport.backend.oauth.core.db.mixins.base import BaseModelMixin


class DeletionMixin(BaseModelMixin):
    deleted = EavAttr()

    @property
    def is_deleted(self):
        return bool(self.deleted) and self.deleted <= now()
