# -*- coding: utf-8 -*-
from passport.backend.oauth.core.common.utils import now
from passport.backend.oauth.core.db.eav import EavAttr
from passport.backend.oauth.core.db.eav.value_serializers import make_collection_serializer
from passport.backend.oauth.core.db.mixins.base import BaseModelMixin


class OwnershipMixin(BaseModelMixin):
    owner_uids = EavAttr()
    owner_groups = EavAttr()
    _owner_group_uids = EavAttr('owner_group_uids')  # уиды, входящие в owner_groups

    @property
    def owners(self):
        return set(self.owner_uids) | set(self._owner_group_uids)

    def is_owned_by(self, uid):
        return uid in self.owners

    @classmethod
    def by_owner(cls, uid, allow_deleted=False):
        return cls.by_index(
            'owner',
            uids=[uid],
            allow_deleted=allow_deleted,
        )

    @staticmethod
    def make_values_for_owners_index(all_values):
        unique_uids = set(
            list(all_values.get('owner_uids', [])) + list(all_values.get('owner_group_uids', [])),
        )
        return {
            'modified_at': now(),
            'uids': make_collection_serializer()(
                sorted(unique_uids),
            ),
        }
