# -*- coding: utf-8 -*-
from typing import Set

from django.conf import settings
from passport.backend.oauth.core.db.eav import EavAttr
from passport.backend.oauth.core.db.mixins.base import BaseModelMixin
from passport.backend.oauth.core.db.scope import (
    has_x_token_scope,
    Scope,
)


class ScopesMixin(BaseModelMixin):
    scope_ids = EavAttr()

    @property
    def _raw_scopes(self) -> Set[Scope]:
        return set([Scope.by_id(scope_id) for scope_id in self.scope_ids])

    @property
    def scopes(self) -> Set[Scope]:
        scopes = set([scope for scope in self._raw_scopes if not scope.is_deleted])
        if not scopes:
            scopes = {Scope.by_keyword(settings.CLIENT_DEFAULT_SCOPE_KEYWORD)}
        return scopes

    @property
    def deleted_scopes(self) -> Set[Scope]:
        return set([scope for scope in self._raw_scopes if scope.is_deleted])

    @property
    def has_xtoken_grant(self) -> bool:
        """Есть ли у объекта x-токенный скоуп"""
        return has_x_token_scope(self.scopes)

    def set_scopes(self, scopes: list[Scope]):
        self.scope_ids = [scope.id for scope in scopes]
