# -*- coding: utf-8 -*-
from datetime import timedelta

from django.conf import settings
from passport.backend.oauth.core.common.utils import now
from passport.backend.oauth.core.db.eav import EavAttr
from passport.backend.oauth.core.db.mixins.base import BaseModelMixin


class TtlMixin(BaseModelMixin):
    expires = EavAttr()

    @property
    def ttl(self):
        """Число секунд, которое объект ещё будет жив (или None для непротухающих)"""
        return int(timedelta.total_seconds(self.expires - now())) if self.expires else None

    @property
    def is_expired(self):
        """Протух ли объект"""
        return self.ttl is not None and self.ttl <= 0

    @property
    def can_be_operated(self):
        """Можно ли апдейтить этот объект, не опасаясь гонок с его близким протуханием"""
        return not self.expires or self.ttl >= settings.MINIMAL_TTL_FOR_OPERATING
