# -*- coding: utf-8 -*-
from django.conf import settings
from passport.backend.oauth.core.common.error_logs import log_warning
from passport.backend.oauth.core.db.eav.dbmanager import (
    get_dbm,
    RAW_DB_EXCEPTIONS,
)
from passport.backend.oauth.core.db.eav.sharder import (
    build_range_shard_function,
    get_sharder,
)


def configure_mysql():
    for db_name, config in settings.MYSQL_CONFIG.items():
        get_dbm(db_name).configure(config)

    shard_function = build_range_shard_function(settings.MYSQL_SHARDING_RANGES)
    for table_name, config in settings.MYSQL_SHARDING_CONFIG.items():
        get_sharder(table_name).configure(config, shard_function)


def prepare_mysql_connections():
    for db_name in settings.MYSQL_CONFIG:
        for engine in get_dbm(db_name).get_all_engines():
            for attempt_no in range(settings.PREPARE_CONNECTION_ATTEMPTS):
                try:
                    conn = engine.connect()
                    conn.execute('select 1')
                    conn.close()
                    # если дошли сюда, то прекращаем попытки прогреть соединение и выходим из цикла
                    break
                except RAW_DB_EXCEPTIONS as e:
                    log_warning('Failed to create db connection: {}, attempt [{}/{}]'.format(
                        str(e),
                        attempt_no + 1,
                        settings.PREPARE_CONNECTION_ATTEMPTS,
                    ))
