# -*- coding: utf-8 -*-
from django.conf import settings
from passport.backend.core.utils.experiments import is_experiment_enabled
from passport.backend.core.utils.version import is_version_left_gte_right
from passport.backend.oauth.core.db.config import get_token_params
from passport.backend.oauth.core.db.device_info import (
    AppPlatform,
    parse_app_platform,
)


def should_issue_stateless(uid, client_id, client_create_time=None,
                           app_id=None, app_platform=None, app_version=None, is_xtoken=False):
    if is_xtoken:
        # х-токены не должны быть stateless в штатных сценариях
        return False

    if (
        parse_app_platform(app_platform) in (AppPlatform.Android, AppPlatform.iOS) and
        client_create_time is not None and
        client_create_time >= settings.FORCE_STATELESS_FOR_AM_CLIENTS_CREATED_AFTER
    ):
        return True

    token_params = get_token_params()
    stateless_rules = token_params.stateless_rules_by_client_id.get(client_id, [])
    if app_id:
        stateless_rules += token_params.stateless_rules_by_app_id.get(app_id, [])

    for rule in stateless_rules:
        if rule.get('client_id'):
            if client_id != rule['client_id']:
                continue
        if rule.get('app_id'):
            if not app_id or app_id != rule['app_id']:
                continue
        if rule.get('app_platform'):
            if not app_platform or parse_app_platform(rule['app_platform']) != parse_app_platform(app_platform):
                continue
        if rule.get('min_app_version'):
            if not app_version or not is_version_left_gte_right(app_version, rule['min_app_version']):
                continue
        if rule.get('denominator') is not None:
            if not is_experiment_enabled(uid, denominator=rule['denominator']):
                continue
        # Все проверки пройдены - можно выдавать stateless
        return True

    # Подходящего правила не нашлось - по умолчанию stateless не выдаём
    return False
