PY3_LIBRARY()

NEED_REVIEW()

OWNER(
    g:passport_python
    eugene311
)

PEERDIR(
    contrib/python/django/django-3
    contrib/python/sqlalchemy/sqlalchemy-1.3

    library/python/django

    passport/backend/core/geobase
    passport/backend/core/portallib
    passport/backend/core/utils

    passport/backend/oauth/core/common
    passport/backend/oauth/core/db/config
    passport/backend/oauth/core/db/eav
    passport/backend/oauth/core/logs

    passport/backend/utils
)

PY_SRCS(
    mixins/__init__.py
    mixins/base.py
    mixins/client_mixin.py
    mixins/deletion_mixin.py
    mixins/ownership_mixin.py
    mixins/scopes_mixin.py
    mixins/ttl_mixin.py
    token/__init__.py
    token/base.py
    token/common_actions.py
    token/normal_token.py
    token/params.py
    token/stateless_token.py
    __init__.py
    acl.py
    client.py
    device_info.py
    errors.py
    limits.py
    psuid.py
    request.py
    schemas.py
    scope.py
    startup.py
    turboapp.py
)

END()

RECURSE(
    config
    eav
)
