# -*- coding: utf-8 -*-
import logging

from passport.backend.oauth.core.logs.base_tskv_logger import BaseTskvLogger
from passport.backend.utils.time import datetime_to_integer_unixtime


graphite_log = logging.getLogger('graphite')


TIMEOUT_RESPONSE_CODE = 'timeout'
SUCCESS_RESPONSE_CODE = 'success'
FAILED_RESPONSE_CODE = 'failed'


class GraphiteLogger(BaseTskvLogger):
    def __init__(self, **context):
        super(GraphiteLogger, self).__init__(
            logger=graphite_log,
            **context
        )

    def _format_time_values(self, datetime_):
        return {
            'unixtime': datetime_to_integer_unixtime(datetime_),
            'timestamp': datetime_.strftime('%d/%b/%Y:%H:%M:%S'),
        }
