# -*- coding: utf-8 -*-
import logging

from passport.backend.oauth.core.logs.base_tskv_logger import BaseTskvLogger
from passport.backend.utils.time import datetime_to_unixtime


event_log = logging.getLogger('historydb.event')


class HistoryDbEventLogger(BaseTskvLogger):
    def __init__(self, **context):
        super(HistoryDbEventLogger, self).__init__(
            logger=event_log,
            **context
        )

    def _format_time_values(self, datetime_):
        return {
            'timestamp': '%.6f' % datetime_to_unixtime(datetime_),
        }


def to_event_log(**kwargs):
    HistoryDbEventLogger().log(**kwargs)
