# -*- coding: utf-8 -*-
import logging

from django.conf import settings
from passport.backend.oauth.core.logs.base_tskv_logger import BaseTskvLogger
from passport.backend.utils.time import datetime_to_integer_unixtime


statbox_log = logging.getLogger('statbox')


class StatboxLogger(BaseTskvLogger):
    def __init__(self, mode, tskv_format='oauth-log', **context):
        super(StatboxLogger, self).__init__(
            logger=statbox_log,
            tskv_format=tskv_format,
            **context
        )
        self.bind_context(mode=mode)

    def _format_time_values(self, datetime_):
        return {
            'timestamp': datetime_.strftime(settings.STATBOX_DATETIME_FORMAT),
            'timezone': settings.TIME_ZONE_OFFSET,
            'unixtime': datetime_to_integer_unixtime(datetime_),
        }


def to_statbox(mode, **kwargs):
    StatboxLogger(mode=mode).log(**kwargs)
