# -*- coding: utf-8 -*-
from passport.backend.library.commander import Commander
from passport.backend.library.nginx_config_generator import enable_logging_to_stdout
from passport.backend.oauth.nginx_conf.build_configs import build
from passport.backend.oauth.nginx_conf.delete_configs import delete


def configure_build_command(commander):
    commander.add_command(
        'build',
        build,
    ).add_argument(
        '-d', '--dir',
        dest='config_dir',
        type=str,
        default='../',
    )


def configure_delete_command(commander):
    commander.add_command(
        'delete',
        delete,
    ).add_argument(
        '-d', '--dir',
        dest='config_dir',
        type=str,
        default='../',
    )


def main():
    commander = Commander()

    enable_logging_to_stdout()
    configure_build_command(commander)
    configure_delete_command(commander)

    commander.invoke()
