# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django_yauth.settings import *
from passport.backend.oauth.settings.admin_settings.env import (
    YENV_NAME,
    YENV_TYPE,
)


YAUTH_TYPE = 'intranet'
YAUTH_USE_OAUTH = False
YAUTH_USE_SITES = False
YAUTH_MECHANISMS = [
    'django_yauth.authentication_mechanisms.cookie',
]

_PASSPORT_HOSTS = {
    'intranet': {
        'production': 'passport.yandex-team.',
        'rc': 'passport-rc.yandex-team.',
        'testing': 'passport-test.yandex-team.',
    },
    'localhost': {
        'development': 'passport-test.yandex.',
        'testing': 'passport-test.yandex.',
        'rc': 'passport-rc.yandex',
        'production': 'passport.yandex.',
    },
}
_PASSPORT_HOST = _PASSPORT_HOSTS[YENV_NAME][YENV_TYPE]

for key, value in YAUTH_PASSPORT_URLS[YAUTH_TYPE].items():
    YAUTH_PASSPORT_URLS[YAUTH_TYPE][key] = value.replace('passport.yandex-team.', _PASSPORT_HOST, 1)
