from passport.backend.oauth.settings.common_settings.env import (
    ENV_NAME,
    ENV_TYPE,
    YENV_TYPE,
)


_ANTIFRAUD_API_PROD_URL = 'https://so-fraud.pers.yandex.net'
_ANTIFRAUD_API_TEST_URL = 'https://fraud-test.so.yandex-team.ru'

_ANTIFRAUD_API_URL = {
    'localhost': {
        'production': _ANTIFRAUD_API_PROD_URL,
        'rc': _ANTIFRAUD_API_PROD_URL,
        'testing': _ANTIFRAUD_API_TEST_URL,
        'development': '',
    },
}

_ANTIFRAUD_AUTH_SUB_CHANNEL = {
    'production': 'login',
    'rc': 'login',
    'testing': 'test-login',
    'development': 'login',  # только для тестов
}

ANTIFRAUD_AUTH_SUB_CHANNEL = _ANTIFRAUD_AUTH_SUB_CHANNEL.get(YENV_TYPE, '')

ANTIFRAUD_API_URL = _ANTIFRAUD_API_URL.get(ENV_NAME, {}).get(ENV_TYPE)
ANTIFRAUD_API_TIMEOUT = 0.3
ANTIFRAUD_API_RETRIES = 1

ANTIFRAUD_SCORE_ENABLE = ENV_NAME == 'localhost' and ENV_TYPE in ('rc', 'production')
ANTIFRAUD_SCORE_DRY_RUN = False
