# -*- coding: utf-8 -*-
from __future__ import absolute_import

from passport.backend.oauth.settings.api_settings.env import (
    ENV_NAME,
    ENV_TYPE,
)
from passport.backend.oauth.settings.common_settings.blackbox import *


BB_ATTR_APP_PASSWORDS_ON = 'account.enable_app_password'
BB_ATTR_AVAILABLE = 'account.is_available'
BB_ATTR_PASSWORD_CHANGE_REASON = 'password.forced_changing_reason'
BB_ATTR_PASSWORD_CREATING_REQUIRED = 'password.is_creating_required'
BB_ATTR_PDD_AGREEMENT_ACCEPTED = 'account.is_pdd_agreement_accepted'
BB_ATTR_SMS_2FA_ON = 'account.sms_2fa_on'
BB_ATTR_IS_SHARED = 'account.is_shared'
BB_ATTR_IS_CHILD = 'account.is_child'

BLACKBOX_ATTRIBUTES = BLACKBOX_ATTRIBUTES + (
    BB_ATTR_APP_PASSWORDS_ON,
    BB_ATTR_AVAILABLE,
    BB_ATTR_PASSWORD_CHANGE_REASON,
    BB_ATTR_PASSWORD_CREATING_REQUIRED,
    BB_ATTR_PDD_AGREEMENT_ACCEPTED,
    BB_ATTR_SMS_2FA_ON,
    BB_ATTR_IS_SHARED,
    BB_ATTR_IS_CHILD,
)


# логин, который используется в ручке /ping,
# чтобы проверить работоспособность blackbox
if ENV_NAME == 'intranet':
    if ENV_TYPE == 'testing':
        BLACKBOX_AVAILABILITY_TEST_LOGIN = 'bb-availability-test'
    else:
        BLACKBOX_AVAILABILITY_TEST_LOGIN = 'blackbox-monitor'
elif ENV_NAME == 'stress':
    BLACKBOX_AVAILABILITY_TEST_LOGIN = 'blackbox-monitor'
else:
    BLACKBOX_AVAILABILITY_TEST_LOGIN = 'blackbox-availability-test'
