# -*- coding: utf-8 -*-
from __future__ import absolute_import

from passport.backend.oauth.settings.api_settings.env import (
    ENV_NAME,
    ENV_TYPE,
)


CAPTCHA_URL = 'http://api.captcha.yandex.net/'

# таймаут запроса к серверу капчи
CAPTCHA_TIMEOUT = 1
# количество попыток запроса к серверу капчи
CAPTCHA_RETRIES = 2
# количество разрешенных проверок одной и той же капчи
CAPTCHA_CHECKS = 1

# неиспользуемые настройки
CAPTCHA_LANGUAGE_MATCHING = {}
CAPTCHA_COUNTRY_MATCHING = {}
WAVE_CAPTCHA_LANGUAGE_MATCHING = {}
WAVE_CAPTCHA_COUNTRY_MATCHING = {}

CAPTCHA_TYPE = 'nbg'

CAPTCHA_SCALE_MATCHING = {
    CAPTCHA_TYPE: {
        2: 'nbg_s2',
        3: 'nbg_s3',
    },
}

MAX_CAPTCHA_KEY_LENGTH = MAX_CAPTCHA_ANSWER_LENGTH = 100

# Пониженные требования капчи для специальных тестовых логинов: показываем не всем, принимаем любой ответ
DEGRADATE_CAPTCHA_FOR_TEST_LOGINS = ENV_TYPE in ['development', 'testing']

YANDEX_TEST_LOGIN_PREFIXES = ('yndx', 'yandex-team')
YANDEX_CAPTCHA_NEVER_TEST_LOGIN_PREFIX = 'yndx-captcha-never-'

if ENV_NAME == 'intranet':
    YANDEX_CAPTCHA_ALWAYS_TEST_LOGIN_PREFIX = 'cap1-'
else:
    YANDEX_CAPTCHA_ALWAYS_TEST_LOGIN_PREFIX = 'yndx-captcha-always-'

# В каких странах показывать капчу при перегреве счётчиков в ЧЯ в gt=password
GRANT_TYPE_PASSWORD_CAPTCHA_COUNTRIES = {
    'AM', 'AZ', 'BY', 'EE', 'FI', 'FR', 'GE', 'IL', 'KG', 'KZ', 'LT', 'LV',
    'MD', 'PL', 'RU', 'TJ', 'TM', 'TM', 'TR', 'UA', 'UZ',
}
