# -*- coding: utf-8 -*-
from __future__ import absolute_import

from datetime import datetime
import string

from passport.backend.oauth.settings.api_settings.domains import OAUTH_PUBLIC_HOST_TEMPLATE
from passport.backend.oauth.settings.api_settings.env import (
    ENV_NAME,
    ENV_TYPE,
)
from passport.backend.oauth.settings.api_settings.secrets import (
    PSUID_ENCRYPTION_SECRET,
    PSUID_SIGNATURE_SECRET,
    REFRESH_TOKEN_GENERATION_SECRET,
)
from passport.backend.oauth.settings.common_settings.common import *


INTERNAL_HOSTS = (
    'oauth-internal.yandex.ru',
    'oauth-rc-internal.yandex.ru',
    'oauth-rc-internal.yandex-team.ru',
    'oauth-internal.yandex-team.ru',
    'oauth-test-internal.yandex.ru',
    'oauth-test-internal.yandex-team.ru',
    'oauth-load-internal.yandex.ru',
    '127.0.0.1:8302',  # сюда ходит фронтенд
)
REQUIRE_HTTPS = ENV_TYPE not in ['development', 'testing']
NO_HTTPS_FOR_HOSTS = INTERNAL_HOSTS

# используется в старых ручках и для совместимости
INVALIDATE_TOKENS_ON_CLIENT_CALLBACK_CHANGE = (ENV_NAME != 'intranet')

PROTECT_YANDEX_CLIENTS_FROM_DESTRUCTION = ENV_NAME != 'intranet' and ENV_TYPE in ('rc', 'production')

REQUIRE_DESCRIPTION_FOR_CLIENTS_WAITING_FOR_APPROVAL = True

SEND_EMAILS_ON_CLIENT_EDIT = (ENV_NAME == 'localhost')

DEFAULT_TURBOAPP_SCOPES = ['login:email', 'login:info', 'login:avatar']

DEFAULT_TOKEN_TTL = 3600 * 24 * 365  # 1 год
TOKEN_REFRESH_RATIO = 0.55  # доля остающегося срока жизни, при достижении которой можно подновлять
MINIMAL_TTL_FOR_OPERATING = 30

MINIMAL_TIME_BETWEEN_TOKEN_UPDATING = 3 * 30 * 24 * 3600  # если меньше - токен в БД не подновляем, отдаём как есть

MAX_TOKENS_TO_DELETE_WHEN_ISSUING_NEW = 3

TOKEN_ALIAS_ALPHABET = string.ascii_lowercase
TOKEN_ALIAS_GENERATION_RETRIES = 2

# Допустима ли выдача stateless-токена при невозможности выдать обычный
ALLOW_FALLBACK_TO_STATELESS_TOKENS = ENV_NAME != 'intranet'
ALLOW_FALLBACK_TO_STATELESS_TOKENS_FOR_NON_YANDEX_CLIENTS_AND_PUBLIC_GRANT_TYPES = False  # может быть полезно для ятима

# Выдаём ли stateless в АМ всем новым приложениям
if ENV_TYPE in ('development', 'testing'):
    FORCE_STATELESS_FOR_AM_CLIENTS_CREATED_AFTER = datetime(2020, 5, 12)
else:
    FORCE_STATELESS_FOR_AM_CLIENTS_CREATED_AFTER = datetime(2020, 5, 18)

ACCEPT_LOGIN_ID_FOR_GT_PASSWORD = ENV_TYPE in ('development', 'testing')

# Игнорировать ли отсутствие сесгарда в grant_type=sessionid, когда единственную куку Session_id принесли в параметре
# (а не в заголовке)
ALLOW_SKIP_SESSGUARD_FOR_LEGACY_GT_SESSIONID_USERS = True
# Не выдавать хтокен по куке с непаспортным хостом.
# (Нельзя включать до выключения ALLOW_SKIP_SESSGUARD_FOR_LEGACY_GT_SESSIONID_USERS)
REQUIRE_PASSPORT_HOST_FOR_XTOKEN_BY_GT_SESSIONID = not ALLOW_SKIP_SESSGUARD_FOR_LEGACY_GT_SESSIONID_USERS

REQUEST_ID_LENGTH = 32
REQUEST_UNACCEPTED_TTL = 3600
REQUEST_ACCEPTED_TTL = 600
REQUEST_CODE_LOW_LENGTH = 7
REQUEST_CODE_BELOW_MEDIUM_LENGTH = 8
REQUEST_CODE_MEDIUM_LENGTH = 8
REQUEST_CODE_HIGH_LENGTH = 16

DEVICE_CODE_TTL = 300
DEVICE_CODE_POLL_INTERVAL = 5

if ENV_NAME == 'localhost' and ENV_TYPE == 'production':
    DEFAULT_DEVICE_CODE_VERIFICATION_URL_TEMPLATE = 'https://yandex.%(tld)s/device'
    CUSTOM_DEVICE_CODE_VERIFICATION_URLS_BY_TLD = {
        'ru': 'https://ya.ru/device',
    }
else:
    DEFAULT_DEVICE_CODE_VERIFICATION_URL_TEMPLATE = 'https://%s/device' % OAUTH_PUBLIC_HOST_TEMPLATE
    CUSTOM_DEVICE_CODE_VERIFICATION_URLS_BY_TLD = {}

CLIENT_CALLBACK_FORBIDDEN_SCHEMES = (
    'javascript',
    'vbscript',
    'data',
)

ALLOW_ISSUE_TOKEN_FOR_INSECURE_REDIRECT_URI = False
ALLOW_INSECURE_URIS_FOR_CLIENTS_CREATED_BEFORE = datetime(2017, 11, 27)

AUTH_SDK_PARAM_VALIDATION_DRY_RUN = True

TURBO_APP_MAX_SCOPE_COUNT = 5

MAX_ICON_FILE_SIZE = 1 * 1024 * 1024  # 1M

# Максимальное время последнего ввода пароля, для которого мы не просим пользователя
# переввести пароль на опасных операциях. Согласовано с параметром в passport-settings.
PASSWORD_VERIFICATION_MAX_AGE = 30 * 60  # 30 минут


LANGUAGES = ('ru', 'en', 'tr', 'uk')
DEFAULT_LANGUAGE = 'ru'
LANGUAGE_FALLBACK_MAPPING = {
    'et': 'en',  # эстонский
    'fi': 'en',  # финский
    'fr': 'en',  # французский
    'he': 'en',  # иврит
    'id': 'en',  # индонезийский
    'lt': 'en',  # литовский
    'lv': 'en',  # латвийский
    'pl': 'en',  # польский
}


# Файл, доступность которого проверяется в ручке /ping
PING_TEST_FILE = '/usr/lib/yandex/oauth-api/ping.html'


# погрешность сравнения таймстампов, используемых в подписях
TS_CHECK_DELTA = 60


if ENV_NAME == 'localhost' and ENV_TYPE in ('rc', 'production'):
    SKIP_USER_CONFIRM_FOR_CLIENTS = [
        'f1f4d73d7ae24365a64c6d855f090b4f',  # Авто.ру
        '197f6527da4b48a4bde884cd03fca56f',  # Я.Диск
        'a83ca2f0fe4d4de4bdbd6afbc8b75c97',  # Yango Fleet
    ]
elif ENV_NAME == 'intranet' and ENV_TYPE in ('rc', 'production'):
    SKIP_USER_CONFIRM_FOR_CLIENTS = [
        'e6ac8930a3ba49309bab14b0a316bb78',  # YQL
        '70b59643a329456ea204e6589a3e3603',  # YQL test
    ]
else:
    SKIP_USER_CONFIRM_FOR_CLIENTS = []


ALLOW_SMS_2FA_IN_GT_PASSWORD_FOR_CLIENTS = [
    '197f6527da4b48a4bde884cd03fca56f',  # Диск
]

REFRESH_TOKEN_DEFAULT_VERSION = 1
REFRESH_TOKEN_GENERATION_KEYS = {
    1: REFRESH_TOKEN_GENERATION_SECRET,
    2: REFRESH_TOKEN_GENERATION_SECRET,
}


# полное имя потребителя с ip, для которых можно передавать user_ip в кастомном хедере
SUBSTITUTE_USER_IP_CONSUMER = 'mobileproxy_substitute_ip'


PSUID_DEFAULT_VERSION = 1
PSUID_ENCRYPTION_KEYS = {
    1: PSUID_ENCRYPTION_SECRET,
}
PSUID_SIGNATURE_KEYS = {
    1: PSUID_SIGNATURE_SECRET,
}
PSUID_JWT_TTL = 7 * 24 * 3600


# префиксы поддерживаемых групп (владельцев приложений)
if ENV_NAME == 'intranet':
    DEPARTMENT_GROUP_PREFIXES = [
        'staff',
    ]
elif ENV_TYPE in ('development', 'testing'):
    DEPARTMENT_GROUP_PREFIXES = [
        'test',
    ]
else:
    DEPARTMENT_GROUP_PREFIXES = []


if ENV_NAME == 'localhost' and ENV_TYPE in {'rc', 'production'}:
    CLIENT_ID_TO_DOMAIN = {}
    EXTERNAL_MANAGE_DEFAULT_PHONES_ALLOWED_CLIENT_ID = set()
else:
    CLIENT_ID_TO_DOMAIN = {
        'b42c3d9532354a13a444d78c6cab67b1': 'vadimkhoroshilov.ru',
        'f1b8eb8a82dc436bab1995f58360abf0': 'vadikdomain.ru',
    }
    EXTERNAL_MANAGE_DEFAULT_PHONES_ALLOWED_CLIENT_ID = {'b42c3d9532354a13a444d78c6cab67b1'}


if ENV_NAME == 'localhost':
    OAUTH_MANAGE_CLIENTS_SCOPE_KEYWORD = 'oauth:manage_clients'
    EXTERNAL_MANAGE_CLIENT_SCOPES = ['login:info', 'login:email', 'login:birthday', 'login:avatar']
