# -*- coding: utf-8 -*-
from __future__ import absolute_import

from passport.backend.oauth.settings.api_settings.env import (
    ENV_NAME,
    ENV_TYPE,
)


_OAUTH_PUBLIC_HOST_TEMPLATES = {
    'localhost': {
        'development': 'oauth-dev-bionic.yandex.%(tld)s',
        'testing': 'oauth-test.yandex.%(tld)s',
        'rc': 'oauth-rc.yandex.%(tld)s',
        'production': 'oauth.yandex.%(tld)s',
    },
    'intranet': {
        'development': 'tvm-dev.yandex-team.%(tld)s',
        'testing': 'oauth-test.yandex-team.%(tld)s',
        'rc': 'oauth-rc.yandex-team.%(tld)s',
        'production': 'oauth.yandex-team.%(tld)s',
    },
    'stress': {
        'stress': 'oauth-load.yandex.%(tld)s',
    },
}
OAUTH_PUBLIC_HOST_TEMPLATE = _OAUTH_PUBLIC_HOST_TEMPLATES[ENV_NAME][ENV_TYPE]


if ENV_NAME == 'localhost' and ENV_TYPE in ('rc', 'production'):
    OAUTH_TLDS = (
        'ru',
        'ua',
        'com',
        'com.tr',
        'by',
        'kz',
        'fr',  # Франция
        'az',  # Азербайджан
        'com.am',  # Армения
        'com.ge',  # Грузия
        'co.il',  # Израиль
        'kg',  # Киргизия
        'lt',  # Латвия
        'lv',  # Литва
        'md',  # Молдавия
        'tj',  # Таджикистан
        'tm',  # Туркмения
        'uz',  # Узбекистан
        'ee',  # Эстония
    )
else:
    OAUTH_TLDS = ('ru', )


TLD_TO_LANG_MAPPING = {
    'com': 'en',
    'com.tr': 'tr',
    'ua': 'uk',
    'ru': 'ru',
}
