# -*- coding: utf-8 -*-
from __future__ import absolute_import

from passport.backend.api.settings.blacklisted_as.blacklisted_as import BLACKLISTED_AS_LIST  # noqa
from passport.backend.oauth.settings.api_settings.env import (
    ENV_NAME,
    ENV_TYPE,
)


# grant_type, для использования которых не обязательно заводить потребителя в грантушке
DEFAULT_GRANT_TYPES = (
    'authorization_code',
    'device_code',
    'password',
    'x-token',
    'sessionid',
    'client_credentials',
    'ssh_key',
    'passport_assertion',  # но этот grant_type закрыт грантами от всех, кроме Паспорта
    'refresh_token',
)
ALLOW_GRANT_TYPE_SSH_KEY = ENV_NAME == 'intranet'

# Типы аккаунтов (алиасов), для которых возможны ограничения (определяемые грантами) на выдачу токенов
LIMITED_ACCOUNT_TYPES = (
    'phonish',
    'mailish',
    'kolonkish',
)


# grant_type, которые разрешаем использовать только явно разрешённым приложениям
FORBID_NONPUBLIC_GRANT_TYPES = ENV_TYPE in ['rc', 'production']

if ENV_NAME == 'intranet':
    NONPUBLIC_GRANT_TYPES = (
        'sessionid',
    )

    ALLOW_NONPUBLIC_GRANT_TYPES_FOR_CLIENTS_FROM_YANDEX_IPS = ALLOW_NONPUBLIC_GRANT_TYPES_FOR_CLIENTS_FROM_INTERNET = {
        'sessionid': {
            '8330368a92b0486692dfe072c291418f',  # АМ
        },
    }
else:
    NONPUBLIC_GRANT_TYPES = (
        'password',
        'sessionid',
    )

    _PUBLIC_GRANT_TYPE_PASSWORD_CLIENTS = {
        '23cabbbdc6cd418abb4b39c32c41195d',  # Музыка
        'c906d379328e4541a6d06e4894f2a03b',  # Директ.Командер
        'c135345132e9449dab6416f3cc34ffab',  # Директ.Командер
        '197f6527da4b48a4bde884cd03fca56f',  # Диск
        'c0ebe342af7d48fbbbfcf2d2eedb8f9e',  # АМ
    }

    _GRANT_TYPE_PASSWORD_FROM_YANDEX_IPS = {
        # Продакшн-приложения:
        'de4a869062c44789bc82b0d1de89cf17',  # Яндекс.Элементы
        '3ffed0120b4644589869c11317bbddf4',  # Яндекс.Маркет
        '7a54f58d4ebe431caaaa53895522bf2d',  # Яндекс.Почта
        'eea3d32c206a45dab4848ddd88ccfe7d',  # Джаббер-сервер
        '6bb9bdb1a3f24a6982bedf179f9850e4',  # VINS
        'c9a234d49f724f1fbff15c8fb88e81bf',  # Ya.Disk
        'ff90127313fd4378873d6b57914e8e11',  # Мобильный Диск
        '6cd8c99f10f14b8c838110dd4e8c6b16',  # Яндекс.Диск: X-token
        '6f81a43e8998487fa4b7d045c03a793b',  # Директ Коммандер стафф
        '0618394846eb4d9589a602f80ce013d6',  # Яндекс.Музыка: X-Token
        '0387a48a5ada426c9348158ca3ab1db4',  # Мобильная Яндекс.Музыка
        'd7dc93be84f240228d48457003389dcd',  # Яндекс.Директ X-Token
        'dd5f0f7999b34b859f6392927790c2b2',  # Яндекс.Лончер: X-token
        '9f2a9b1789c8460399bc79cc157d1561',  # Яндекс.Карты: X-token
        '76c64e9b35f641b5a9bbfbea5546bb45',  # Яндекс.Поиск: X-token
        '0a38e86a352e44d78042e822428941ea',  # Яндекс.Навигатор: X-Token
        '468c22e0dbe245f5857ae186228f46f6',  # Яндекс.Почта X-Token
        '9252f8db603e476490789c302e20eb3a',  # Яндекс.Ключ
        '095bbc9e34464460b3a9cc6922af2fb0',  # Яндекс.Браузер: X-Token
        'fb3dd148c51c431f97079da78a298bcf',  # Яндекс.Браузер
        'd19bfc1b498b4bef9408a51266404655',  # РСЯ (https://ml.yandex-team.ru/thread/2370000002995601409/)
        'a6967ffb1b86409d8497fc20cf66570f',  # легаси, используется как минимум старыми Почтой и Картами
        'be0ba1ba871b44f497345dc8c6659adf',  # легаси, предположительно мобильные Почта или Диск
        '37b26c235895402d9a8e70253237ab1a',  # b2b Логистики
        # Тестовые приложения (в продакшн-окружении):
        '75055462dc614df597bc530792b4a238',  # тестовое PriceLabs (https://ml.yandex-team.ru/thread/2370000003076659569)
        'a247cf19552248e3be81ed2b024d4275',  # RC PriceLabs (https://ml.yandex-team.ru/thread/2370000003076659569)
        '52d1d7f249094148ac02edc9e1a310b3',  # для тестирования SMTP
        'fecea27b746844ca89d9cd1223da1a8f',  # приложение для тестов ЧЯ
        'f14c3df749a64240be66b5c715cc8557',  # тестовое приложение АМ
        'e7618c5efed842be839cc9a580be94aa',  # тестовое приложение мобильной Почты
        'f38266b6277745e5915cac8a9f621127',  # тестовое приложение Ксивы
        'a7246d8d0dc04e44b1692162c21ab339',  # тестовое приложение IMAP
        '2d437c8ecc96493e9a62729b2f4059ac',  # тестовое приложение Адресной книги
        '4b98a517d504439fa90ce9872ad7b5ec',  # тестовое приложение Диска (webdav)
        '4dd9e59cba25485496b03376ceda38ee',  # тестовое приложение Диска (api)
        '6c31bcd2f7204ebe96a5591fd516284d',  # тестовое приложение Диска
        '07cdfe530d2649e8a1ef8484fd50633d',  # тестовое приложение Стора
        'd25959f151294768beec6825425b1dd3',  # стресс-тестирование remote-access
        'cb88ccb127534d2785e93aa36d23757b',  # автотесты мобильного Диска (OAUTHREG-34)
        'c5d10c291e284212ae979b7b4c8963f6',  # автотесты Thirium (PASSP-28544)
        'b1feea92d9b54f5fbff3f26da1818381',  # автотесты мобильной Музыки
        'bf09d4b514334abfa0114ba049009c87',  # тестовое приложение Почты
        '2d58fb08d4174e38808f10581774fd32',  # стресс-тестирование Карт
        '197a1215fa504edc982da3a464800ab1',  # тестирование Карт (PASSPORTDUTY-291)
        # Тестовые приложения OAuth (в продакшн-окружении):
        '6ffda86fbae743579148d1175d06bb8e',
        '40bb6712cba048f4846f791cad6dfe4e',
        '638c0795ba54447a9f11da22326febd4',
        '4d487afcdebe48fab2a57a13a6a5864d',
        '55c818af1f8c4239be0a07d169dec39a',
        '46b19a802e7b4b0e86c63f2e07f3b24a',
        'f6d14ee679eb491db1564cb86d57a0d7',
        '570d27b71de84c828bce9b29b90397c4',
        '8442130bd94f4132a1e387978661d759',
        '0e78c7b30f1f4687acc08a85cceb15a4',
        '183f2baca8f9457da9a9ff17a17ce6f9',
        'dbe5c1ce8c154f1c827c7365ef8dc51b',
        'e09ee6e358364acc9e8ce2047028b70b',
        'd3fb1fc2252041d78190313b2ff99c9b',
        '78a42dc91e7b456d915e6d876832c3ba',
        '9a26d5b1c4834e44b03099efef0bd820',
        '518cd5fdca58444ba3678bb3b44a1426',
    }

    _PUBLIC_GRANT_TYPE_SESSIONID_CLIENTS = {
        # Продакшн-приложения:
        'c0ebe342af7d48fbbbfcf2d2eedb8f9e',  # АМ
        'fb3dd148c51c431f97079da78a298bcf',  # Яндекс.Браузер
        '49c545918c574ac28dd7d27e8297065a',  # Элементы Яндекса: Почта
        'f4c18115b1cf4902b0c592d7b33d5922',  # Голосовой помощник Алиса
        'b8c9a29dec8d49449af8e834f01a4334',  # Яндекс.Метрика в ЛК Яндекс.Маркета
        '095bbc9e34464460b3a9cc6922af2fb0',  # Яндекс.Браузер: X-Token
        '197f6527da4b48a4bde884cd03fca56f',  # Яндекс.Диск
        '454430d53f2947fbadc327247c7b106e',  # Яндекс.Взгляд
        '23cabbbdc6cd418abb4b39c32c41195d',  # Яндекс.Музыка
        'f0f349c380134434a7daa5693111b462',  # Элементы Яндекса для Я.Браузера
        '8ba9bcaf30dd47ea976c6973201f1410',  # Элементы Яндекса для Chrome
        'd53a117f9ee247ab93ada3b87fe5e952',  # Элементы Яндекса для Firefox
        '1ea19c944e414c65b0711bd01accba48',  # Элементы Яндекса для IE
        '4ecc40cd85d94f0e8f562b1cd541a30d',  # Блокнот картографа Народной карты
        '692e1f5c03714cb086d33018058f8d4b',  # Блокнот картографа Народной карты (testing)
        '49ce442e022b4ae89ab4960d45d6cdd8',  # Ume Browser: XToken
        'ff90127313fd4378873d6b57914e8e11',  # Мобильный Яндекс.Диск
        '3ffed0120b4644589869c11317bbddf4',  # Яндекс.Маркет
    }

    _GRANT_TYPE_SESSIONID_FROM_YANDEX_IPS = {
        # Тестовые приложения OAuth (в продакшн-окружении):
        '8442130bd94f4132a1e387978661d759',
        '183f2baca8f9457da9a9ff17a17ce6f9',
    }

    ALLOW_NONPUBLIC_GRANT_TYPES_FOR_CLIENTS_FROM_YANDEX_IPS = {
        'password': _GRANT_TYPE_PASSWORD_FROM_YANDEX_IPS | _PUBLIC_GRANT_TYPE_PASSWORD_CLIENTS,
        'sessionid': _GRANT_TYPE_SESSIONID_FROM_YANDEX_IPS | _PUBLIC_GRANT_TYPE_SESSIONID_CLIENTS,
    }

    ALLOW_NONPUBLIC_GRANT_TYPES_FOR_CLIENTS_FROM_INTERNET = {
        'password': _PUBLIC_GRANT_TYPE_PASSWORD_CLIENTS,
        'sessionid': _PUBLIC_GRANT_TYPE_SESSIONID_CLIENTS,
    }


# Приложения, которые могут получать токены только для аккаунтов определённого типа
if ENV_NAME == 'localhost' and ENV_TYPE in ('rc', 'production'):
    CLIENTS_LIMITED_BY_ACCOUNT_TYPE = {
        '71a6771b959845b2aba6b7619668d12f': {'pdd'},  # Настройка Яндекс.Почты для домена
        '82b8a7c3d51a4ac3a8b0417f4140a00a': {'pdd'},  # Вход в Яндекс через Почту для домена
    }
elif ENV_NAME == 'localhost' and ENV_TYPE in ('development', 'testing'):
    CLIENTS_LIMITED_BY_ACCOUNT_TYPE = {
        'c543097aaa0849b1a03ca3122734d917': {'pdd'},  # trusted-pdd-partner
        '92017e69d6af47ce997e08e6c0be52b8': {'pdd'},  # pdd-back-to-wmi
    }
else:
    CLIENTS_LIMITED_BY_ACCOUNT_TYPE = {}


# Настройки rate limits
ENABLE_RATE_LIMITS = ENV_NAME == 'localhost'
# Конкретные значения лимитов (запросов в минуту)
TOKEN_RATE_LIMIT_CLIENT_ID = 1000
TOKEN_RATE_LIMIT_IP = 100
TOKEN_RATE_LIMIT_UID = 25
DEVICE_CODE_RATE_LIMIT_IP = 10

if ENV_TYPE == 'testing':
    # В тестинге повышаем лимиты
    TOKEN_RATE_LIMIT_IP = 1000
    TOKEN_RATE_LIMIT_UID = 50
