# -*- coding: utf-8 -*-
from passport.backend.oauth.settings.common_settings.logs import *


LOG_PATH = '/var/log/yandex/oauth-api/'

LOGGING = make_logging_config(
    log_path=LOG_PATH,
    extra_handlers={
        'antifraud': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'antifraud.log',
            'formatter': 'simple',
        },
        'credentials': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'credentials.log',
            'formatter': 'simple',
        },
        'db_cleaner': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'management/db_cleaner.log',
            'formatter': 'default',
        },
        'dump_clients_to_yt': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'management/dump_clients_to_yt.log',
            'formatter': 'default',
        },
        'owner_groups_updater': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'management/owner_groups_updater.log',
            'formatter': 'default',
        },
    },
    extra_loggers={
        'antifraud': {
            'handlers': ['antifraud'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'credentials': {
            'handlers': ['credentials'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'management.db_cleaner': {
            'handlers': ['db_cleaner', 'console'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'management.dump_clients_to_yt': {
            'handlers': ['dump_clients_to_yt', 'console'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'management.owner_groups_updater': {
            'handlers': ['owner_groups_updater', 'console'],
            'level': 'DEBUG',
            'propagate': False,
        },
    },
)
