# -*- coding: utf-8 -*-
from __future__ import absolute_import

from passport.backend.oauth.settings.api_settings.env import (
    ENV_NAME,
    ENV_TYPE,
)


_MONEY_PAYMENT_AUTH_API_URLS = {
    'localhost': {
        'production': 'https://paymentauth.yamoney.ru/api/',
        'testing': 'https://oauth.yandex.api-proxy.ymdev.yandex.ru/api/',
    },
    'intranet': {
        'production': '',
        'rc': '',
        'testing': '',
        'development': '',
    },
    'stress': {
        'stress': '',
    },
}
_MONEY_PAYMENT_AUTH_API_URLS['localhost']['development'] = _MONEY_PAYMENT_AUTH_API_URLS['localhost']['testing']
_MONEY_PAYMENT_AUTH_API_URLS['localhost']['rc'] = _MONEY_PAYMENT_AUTH_API_URLS['localhost']['production']

MONEY_PAYMENT_AUTH_API_URL = _MONEY_PAYMENT_AUTH_API_URLS[ENV_NAME][ENV_TYPE]
MONEY_PAYMENT_AUTH_API_TIMEOUT = 2 if ENV_TYPE in ['development', 'testing'] else 0.5
MONEY_PAYMENT_AUTH_API_RETRIES = 2


PAYMENT_AUTH_SERVICE_TO_APP_IDS = {
    # Касса
    'checkout': ['ru.yandex.mobile.checkout', 'ru.yandex.mobile.checkout.debug'],
    # скоупы Денег пока не заведены
    # 'money': ['ru.yandex.money', 'ru.yandex.money.debug'],
}

SERVICES_REQUIRING_PAYMENT_AUTH = PAYMENT_AUTH_SERVICE_TO_APP_IDS.keys()


# Фейковый потребитель, с сетей которого можно получать информацию о платёжной авторизации в Я.Логине
PAYMENT_AUTH_INFO_FAKE_CONSUMER = 'money_yalogin_consumer'
