# -*- coding: utf-8 -*-
import re


AM_CLIENT_ID = 'c0ebe342af7d48fbbbfcf2d2eedb8f9e'
DISK_CLIENT_ID = '197f6527da4b48a4bde884cd03fca56f'
MAGNITOLA_APP_IDS = {
    'com.yandex.music.auto',
    'ru.yandex.radio',
    'ru.yandex.yandexnavi',
}
AM_ALLOWED_APP_IDS = {
    'com.edadeal.android',
    'com.yandex.browser',
    'com.yandex.yphone.services',
    'com.yandex.zen',
    'ru.yandex.direct',
    'ru.yandex.disk',
    'ru.yandex.disk.debug',
    'ru.yandex.disk.shareext',
    'ru.yandex.med',
    'ru.yandex.mobile.avia',
    'ru.yandex.mobile.kluch',
    'ru.yandex.mobile.medicine',
    'ru.yandex.mobile.ofd',
    'ru.yandex.rasp',
    'ru.yandex.searchplugin',
    'ru.yandex.searchplugin.beta',
    'ru.yandex.taxi',
    'ru.yandex.translate',
    'ru.yandex.ytaxi',
}

DISK_USER_AGENT_JSON_VALIDATORS = [
    {
        'class': 'RequiredFields',
        'fields': ['os', 'vsn', 'id'],
    },
    {
        'class': 'FieldValueMatch',
        'field': 'os',
        'value_in': ['windows', 'mac', 'cli'],
        'statbox_alias': 'app_platform',
    },
    {
        # Просто чтобы залогировать
        'class': 'FieldDummy',
        'field': 'vsn',
        'statbox_alias': 'app_version',
    },
]
GRANT_TYPE_PASSWORD_REQUEST_VALIDATORS_BY_CLIENT_ID = {
    AM_CLIENT_ID: {
        'ignore_for': [
            # При выполнении любого из условий этой секции
            # все дальнейшие валидации для этого client_id производиться не будут
            {
                'class': 'FieldValueMatch',
                'field': 'app_id',
                'value_in': MAGNITOLA_APP_IDS,
            },
        ],
        'validators': [
            {
                'class': 'RequiredFields',
                'fields': ['deviceid', 'app_id', 'env.user_agent'],
            },
            {
                'class': 'FieldValueMatch',
                'field': 'app_id',
                'value_in': AM_ALLOWED_APP_IDS,
            },
            {
                'class': 'FieldValueMatch',
                'field': 'env.user_agent',
                'regex': re.compile(r'^com\.yandex\.mobile\.auth\.sdk/([^ ]+)'),
            },
        ],
    },
    DISK_CLIENT_ID: {
        'validators': [
            {
                'class': 'RequiredFields',
                'fields': ['env.user_agent'],
            },
            {
                'class': 'FieldValueMatch',
                'field': 'env.user_agent',
                'experiment_denominator': 0,
                'regex': re.compile(r'^Yandex\.Disk (?P<ua_json>.+)$'),
                're_group_validators': [
                    {
                        'class': 'FieldValueJson',
                        'field': 'ua_json',
                        'to_statbox': False,
                        'validators': DISK_USER_AGENT_JSON_VALIDATORS,
                    },
                ],
            },
        ],
    },
}


GRANT_TYPE_PASSWORD_OUTDATED_CLIENTS = {
    'c906d379328e4541a6d06e4894f2a03b',  # Директ.Командер
    'c135345132e9449dab6416f3cc34ffab',  # Директ.Командер
}

OUTDATED_CLIENT_COUNTRIES_LANG_RU = {
    'AM', 'AZ', 'BY', 'GE', 'KG', 'KZ', 'MD', 'RU', 'TJ', 'TM', 'UA', 'UZ',
}

OUTDATED_CLIENT_MESSAGE_RU = 'Вы используете устаревшую версию приложения: https://ya.cc/dc-troubles-ru'
OUTDATED_CLIENT_MESSAGE = 'You are using an outdated version of the application https://ya.cc/dc-troubles'
