# -*- coding: utf-8 -*-
# isort:skip_file
import os
from imp import load_source


secret_settings = None

for config_file in (
    '/usr/lib/yandex/oauth-secrets/local_settings.py',
    os.path.join(os.path.dirname(__file__), 'default.py'),
):
    try:
        secret_settings = load_source('secret_settings', config_file)
        break
    except IOError:
        pass

if not secret_settings:
    from passport.backend.oauth.settings.api_settings.secrets import default as secret_settings


# логин-пароль для ro-доступа к БД
DB_SLAVE_USER = secret_settings.DB_SLAVE_USER
DB_SLAVE_PASSWORD = secret_settings.DB_SLAVE_PASSWORD
# логин-пароль для rw-доступа к БД
DB_MASTER_USER = secret_settings.DB_MASTER_USER
DB_MASTER_PASSWORD = secret_settings.DB_MASTER_PASSWORD
# ключ симметричного шифрования для получения refresh-токенов
REFRESH_TOKEN_GENERATION_SECRET = secret_settings.REFRESH_TOKEN_GENERATION_SECRET
# ключ симметричного шифрования для шифрования данных в PSUID
PSUID_ENCRYPTION_SECRET = secret_settings.PSUID_ENCRYPTION_SECRET
# ключ для подписи PSUID
PSUID_SIGNATURE_SECRET = secret_settings.PSUID_SIGNATURE_SECRET
# OAuth-токен для чтения и записи в YT
YT_OAUTH_TOKEN = secret_settings.YT_OAUTH_TOKEN
