# -*- coding: utf-8 -*-
from __future__ import absolute_import

from passport.backend.oauth.settings.api_settings.env import (
    ENV_NAME,
    ENV_TYPE,
)


_STAFF_API_URLS = {
    'intranet': {
        'production': 'https://staff-api.yandex-team.ru',
        'rc': 'https://staff-api.yandex-team.ru',
        'testing': '',  # тестовый стафф пока не согласован с тестовым ЧЯ
        'development': 'https://staff-api.test.yandex-team.ru',  # в ятим-деве работаем с боевыми аккаунтами
    },
    'localhost': {
        'development': 'https://staff-api.yandex-team.ru',  # для ручных тестов
        'testing': '',
        'rc': '',
        'production': '',
    },
    'stress': {
        'stress': '',
    },
}
STAFF_API_URL = _STAFF_API_URLS[ENV_NAME][ENV_TYPE]
STAFF_API_TIMEOUT = 3
STAFF_API_RETRIES = 2


_STAFF_OAUTH_CLIENT_IDS = {
    'intranet': {
        'production': 'f3d8babe223e45b1a3cd4b3b50b1a670',
        'rc': 'f3d8babe223e45b1a3cd4b3b50b1a670',
        'testing': '',
        'development': '',
    },
    'localhost': {
        'development': '',
        'testing': '',
        'rc': '',
        'production': '',
    },
    'stress': {
        'stress': '',
    },
}
STAFF_OAUTH_CLIENT_ID = _STAFF_OAUTH_CLIENT_IDS[ENV_NAME][ENV_TYPE]

_STAFF_ROBOT_UIDS = {
    'intranet': {
        'production': 1120000000021014,
        'rc': 1120000000021014,
        'testing': None,
        'development': None,
    },
    'localhost': {
        'development': None,
        'testing': None,
        'rc': None,
        'production': None,
    },
    'stress': {
        'stress': None,
    },
}
STAFF_ROBOT_UID = _STAFF_ROBOT_UIDS[ENV_NAME][ENV_TYPE]
