# -*- coding: utf-8 -*-
from passport.backend.oauth.settings.api_settings.env import (
    ENV_NAME,
    ENV_TYPE,
)


_YDB_ENDPOINTS = {
    'localhost': {
        'development': 'ydb-ru-prestable.yandex.net:2135',
        'testing': 'ydb-ru-prestable.yandex.net:2135',
        'rc': 'ydb-ru.yandex.net:2135',
        'production': 'ydb-ru.yandex.net:2135',
    },
    'intranet': {
        'development': '',
        'testing': '',
        'rc': '',
        'production': '',
    },
    'stress': {
        'stress': '',
    },
}
YDB_ENDPOINT = _YDB_ENDPOINTS[ENV_NAME][ENV_TYPE]


YDB_TURBOAPP_PARTNERS_DATABASE = '/ru/passport-data/prod/turboapp_partners'
if ENV_TYPE in {'development', 'testing'}:
    YDB_TURBOAPP_PARTNERS_DATABASE = '/ru-prestable/passport-data/prestable/turboapp_partners'

YDB_TURBOAPP_PARTNERS_ENABLED = ENV_NAME == 'localhost'

YDB_RETRIES = 0  # Будет 1 запрос и 0 попыток его повторить
YDB_CONNECTION_TIMEOUT = 1.000
YDB_GET_SESSION_TIMEOUT = 0.150
YDB_DEADLINE = 0.750
YDB_TIMEOUT = 0.450
YDB_READ_LIMIT = 10

YDB_USE_TVM = True
