# -*- coding: utf-8 -*-
from __future__ import absolute_import

import os

from passport.backend.oauth.settings.common_settings.env import (
    ENV_NAME,
    ENV_TYPE,
)


current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))
IS_UNDER_TESTS = os.environ.get('YA_TEST_RUNNER')
DEBUG = IS_UNDER_TESTS or (ENV_TYPE == 'development' and current_user not in ('oauth', 'root', 'www-data'))

SECURE_PROXY_SSL_HEADER = ('HTTP_X_REAL_SCHEME', 'https')

GRANTS_CONFIG_CACHE_TIME = 60


TOKEN_ALIAS_LENGTH = 16


# Если по какой-то причине из приложения удаляется последний скоуп - вместо него добавляется данный
CLIENT_DEFAULT_SCOPE_KEYWORD = 'login:email'

if ENV_NAME == 'localhost':
    DEFAULT_PHONE_SCOPE_KEYWORD = 'login:default_phone'
else:
    DEFAULT_PHONE_SCOPE_KEYWORD = None
CAN_TURBOAPPS_SEE_DEFAULT_PHONE_SCOPE = DEFAULT_PHONE_SCOPE_KEYWORD is not None

CLIENT_MAX_EVENTS_COUNT = 20


# корневой сертификат для https-соединений
SSL_CA_CERT = '/etc/ssl/certs/ca-certificates.crt'


_DEFAULT_KEY = ''  # шифрование БД в оаусе пока не должно использоваться
ATTRIBUTE_CIPHER_KEYS = {
    1: _DEFAULT_KEY,
    2: _DEFAULT_KEY,
}
