# -*- coding: utf-8 -*-
from __future__ import absolute_import

from frozendict import frozendict
from passport.backend.oauth.settings.common_settings.env import (
    ENV_NAME,
    ENV_TYPE,
)


_BASE_DB_CONFIG = frozendict(
    driver='mysql',
    port=3306,
)


def build_oauth_db_config(secrets):
    _BASE_MASTER_CONFIG = _BASE_DB_CONFIG.copy(
        type='master',
        user=secrets.DB_MASTER_USER,
        password=secrets.DB_MASTER_PASSWORD,
    )
    _BASE_SLAVE_CONFIG = _BASE_DB_CONFIG.copy(
        type='slave',
        user=secrets.DB_SLAVE_USER,
        password=secrets.DB_SLAVE_PASSWORD,
    )

    _MYSQL_CONFIG = {
        'intranet': {
            'development': {},
            'testing': frozendict(
                oauthdbcentral=frozendict(
                    master=_BASE_MASTER_CONFIG.copy(
                        host='cnt-dbm-test.passport.yandex.net',
                        database='oauthdbcentral_yateam',
                    ),
                    slave=_BASE_SLAVE_CONFIG.copy(
                        host='cnt-dbs-test.passport.yandex.net',
                        database='oauthdbcentral_yateam',
                    ),
                ),
                oauthdbshard1=frozendict(
                    master=_BASE_MASTER_CONFIG.copy(
                        host='cnt-dbm-test.passport.yandex.net',
                        database='oauthdbshard1_yateam',
                    ),
                    slave=_BASE_SLAVE_CONFIG.copy(
                        host='cnt-dbs-test.passport.yandex.net',
                        database='oauthdbshard1_yateam',
                    ),
                ),
            ),
            'production': frozendict(
                oauthdbcentral=frozendict(
                    master=_BASE_MASTER_CONFIG.copy(
                        host='yateam-dbm.passport.yandex.net',
                        database='oauthdbcentral',
                    ),
                    slave=_BASE_SLAVE_CONFIG.copy(
                        host='yateam-dbs.passport.yandex.net',
                        database='oauthdbcentral',
                    ),
                ),
                oauthdbshard1=frozendict(
                    master=_BASE_MASTER_CONFIG.copy(
                        host='yateam-dbm.passport.yandex.net',
                        database='oauthdbshard1',
                    ),
                    slave=_BASE_SLAVE_CONFIG.copy(
                        host='yateam-dbs.passport.yandex.net',
                        database='oauthdbshard1',
                    ),
                ),
            ),
        },
        'localhost': {
            'testing': frozendict(
                oauthdbcentral=frozendict(
                    master=_BASE_MASTER_CONFIG.copy(
                        host='cnt-dbm-test.passport.yandex.net',
                        database='oauthdbcentral',
                    ),
                    slave=_BASE_SLAVE_CONFIG.copy(
                        host='cnt-dbs-test.passport.yandex.net',
                        database='oauthdbcentral',
                    ),
                ),
                oauthdbshard1=frozendict(
                    master=_BASE_MASTER_CONFIG.copy(
                        host='cnt-dbm-test.passport.yandex.net',
                        database='oauthdbshard1',
                    ),
                    slave=_BASE_SLAVE_CONFIG.copy(
                        host='cnt-dbs-test.passport.yandex.net',
                        database='oauthdbshard1',
                    ),
                ),
                oauthdbshard2=frozendict(
                    master=_BASE_MASTER_CONFIG.copy(
                        host='cnt-dbm-test.passport.yandex.net',
                        database='oauthdbshard2',
                    ),
                    slave=_BASE_SLAVE_CONFIG.copy(
                        host='cnt-dbs-test.passport.yandex.net',
                        database='oauthdbshard2',
                    ),
                ),
            ),
            'production': frozendict(
                oauthdbcentral=frozendict(
                    master=_BASE_MASTER_CONFIG.copy(
                        host='cnt-dbm.oauth.yandex.net',
                        database='oauthdbcentral',
                    ),
                    slave=_BASE_SLAVE_CONFIG.copy(
                        host='cnt-dbs.oauth.yandex.net',
                        database='oauthdbcentral',
                    ),
                ),
                oauthdbshard1=frozendict(
                    master=_BASE_MASTER_CONFIG.copy(
                        host='cnt-dbm.oauth.yandex.net',
                        database='oauthdbshard1',
                    ),
                    slave=_BASE_SLAVE_CONFIG.copy(
                        host='cnt-dbs.oauth.yandex.net',
                        database='oauthdbshard1',
                    ),
                ),
                oauthdbshard2=frozendict(
                    master=_BASE_MASTER_CONFIG.copy(
                        host='sh2-dbm.oauth.yandex.net',
                        database='oauthdbshard2',
                    ),
                    slave=_BASE_SLAVE_CONFIG.copy(
                        host='sh2-dbs.oauth.yandex.net',
                        database='oauthdbshard2',
                    ),
                ),
            ),
        },
        'stress': {
            'stress': frozendict(
                oauthdbcentral=frozendict(
                    master=_BASE_MASTER_CONFIG.copy(
                        host='passportdb-load.passport.yandex.net',
                        database='oauthdbcentral',
                    ),
                    slave=_BASE_SLAVE_CONFIG.copy(
                        host='passportdb-load.passport.yandex.net',
                        database='oauthdbcentral',
                    ),
                ),
                oauthdbshard1=frozendict(
                    master=_BASE_MASTER_CONFIG.copy(
                        host='passportdb-load.passport.yandex.net',
                        database='oauthdbshard1',
                    ),
                    slave=_BASE_SLAVE_CONFIG.copy(
                        host='passportdb-load.passport.yandex.net',
                        database='oauthdbshard1',
                    ),
                ),
            ),
        },
    }
    _MYSQL_CONFIG['localhost']['development'] = _MYSQL_CONFIG['localhost']['testing']
    _MYSQL_CONFIG['localhost']['rc'] = _MYSQL_CONFIG['localhost']['production']
    _MYSQL_CONFIG['intranet']['rc'] = _MYSQL_CONFIG['intranet']['production']
    return _MYSQL_CONFIG[ENV_NAME][ENV_TYPE]


_SHARD_NAMES = {
    'intranet': {
        'development': ('oauthdbshard1',),
        'testing': ('oauthdbshard1',),
        'production': ('oauthdbshard1',),
    },
    'localhost': {
        'development': ('oauthdbshard1', 'oauthdbshard2'),
        'testing': ('oauthdbshard1', 'oauthdbshard2'),
        'production': ('oauthdbshard1', 'oauthdbshard2'),
    },
    'stress': {
        'stress': ('oauthdbshard1',),
    },
}
_SHARD_NAMES['localhost']['rc'] = _SHARD_NAMES['localhost']['production']
_SHARD_NAMES['intranet']['rc'] = _SHARD_NAMES['intranet']['production']

_MYSQL_SHARDING_CONFIG = {
    'intranet': {
        'development': {'token': {1: 'oauthdbshard1', 2: 'oauthdbshard1'}},
        'production': {'token': {1: 'oauthdbshard1', 2: 'oauthdbshard1'}},
        'rc': {'token': {1: 'oauthdbshard1', 2: 'oauthdbshard1'}},
        'testing': {'token': {1: 'oauthdbshard1', 2: 'oauthdbshard1'}},
    },
    'localhost': {
        'development': {'token': {1: 'oauthdbshard1', 2: 'oauthdbshard2'}},
        'testing': {'token': {1: 'oauthdbshard1', 2: 'oauthdbshard2'}},
        'rc': {'token': {1: 'oauthdbshard1', 2: 'oauthdbshard2'}},
        'production': {'token': {1: 'oauthdbshard1', 2: 'oauthdbshard2'}},
    },
    'stress': {
        'stress': {'token': {1: 'oauthdbshard1', 2: 'oauthdbshard1'}},
    },
}

if ENV_NAME == 'localhost':
    if ENV_TYPE in ('development', 'testing'):
        MYSQL_SHARDING_RANGES = (
            (1, 0),
            (2, 7500000),  # 7.5 * 10**6
        )
    else:
        MYSQL_SHARDING_RANGES = (
            (1, 0),
            (2, 1425 * (10 ** 6)),
            (1, 2770 * (10 ** 6)),
        )
else:
    MYSQL_SHARDING_RANGES = (
        (1, 0),
    )

MYSQL_CONFIG = None  # переопределится позднее
CENTRAL_DB_NAME = 'oauthdbcentral'
SHARD_NAMES = _SHARD_NAMES[ENV_NAME][ENV_TYPE]
MYSQL_SHARDING_CONFIG = _MYSQL_SHARDING_CONFIG[ENV_NAME][ENV_TYPE]

DB_DEFAULT_CONNECT_ARGS = {
    'mysql': frozendict(
        connect_timeout=1,
        read_timeout=1,
        write_timeout=1,
        charset='utf8',
    ),
    'sqlite': frozendict(),
}
DB_RETRIES = 2
DB_RETRY_TIMEOUT = 0
DB_POOL_SIZE = 5
DB_POOL_RECYCLE = 600
DB_POOL_MAX_OVERFLOW = 50
DB_POOL_PRE_PING = True

# Количество попыток сделать запрос в БД при старте приложения
PREPARE_CONNECTION_ATTEMPTS = 1

# Количество попыток коннекта к БД в ручке /ping
DB_AVAILABILITY_TEST_RETRIES = 2
