# -*- coding: utf-8 -*-
from __future__ import absolute_import

import builtins

import yenv


# "Логическое" окружение - с какой базой пользователей работаем. Прокидывается из default_settings.
ENV_NAME = getattr(builtins, 'ENV_NAME', yenv.name)
ENV_TYPE = getattr(builtins, 'ENV_TYPE', yenv.type)

# "Физическое" окружение - где находится машина.
YENV_NAME = yenv.name
YENV_TYPE = yenv.type

# :link: https://a.yandex-team.ru/arcadia/passport/infra/daemons/blackbox/src/oauth/token_embedded_info.cpp
_ENV_IDS = {
    'localhost': {
        'production': 0,
        'rc': 0,
        'testing': 2,
        'development': 2,
    },
    'intranet': {
        'production': 1,
        'rc': 1,
        'testing': 3,
        'development': 3,
    },
    'stress': {
        'stress': 4,
    }
}

ENV_ID = _ENV_IDS[ENV_NAME][ENV_TYPE]
