# -*- coding: utf-8 -*-
from __future__ import absolute_import

from passport.backend.oauth.settings.common_settings.env import (
    ENV_TYPE,
    ENV_NAME,
)


# Настройка выдачи токенов в формате 41 байта
TOKEN_41_BYTE_FORMAT = (ENV_NAME == 'intranet' or ENV_TYPE != 'production')

# Устаревшие но поддерживаемые токены с 2016 года (существуют из-за механизмов продления существующих токенов)
# Расширять по необходимости
DEPRECATED_TOKEN_LENGTH = {
    '32': 32,  # первое поколение токенов с длиной 32
    '34': 34,  # багованное второе поколение с длиной 34 которое так же необходимо поддерживать
    '39': 39,  # Третье поколение с длиной 39
}

# Актуальная на текущий момент длина access_token
# Переместить в deprecated и заменить при изменении при следующей итерации
# Токены с длинами выше REGULAR_TOKEN_LENGTH считаются stateless
REGULAR_TOKEN_LENGTH = 58
