# -*- coding: utf-8 -*-
from passport.backend.oauth.settings.common_settings.common import *


INTERNAL_HOSTS = (
    'tvm-dev-internal.yandex.net',
    'tvm-test-internal.yandex.net',
    'tvm-internal.yandex.net',
    '127.0.0.1:8302',  # сюда ходит фронтенд
)
NO_HTTPS_FOR_HOSTS = INTERNAL_HOSTS

try:
    with open('/etc/yandex/tvm/secret.key') as f:
        _DEFAULT_KEY = f.read().strip()
except IOError:
    _DEFAULT_KEY = ''  # с таким ключом шифрование сломается, но остальная часть кода работать будет

ATTRIBUTE_CIPHER_KEYS = {
    1: _DEFAULT_KEY,
    2: _DEFAULT_KEY,
}

# Файл, доступность которого проверяется в ручке /ping
PING_TEST_FILE = '/usr/lib/yandex/tvm-api/ping.html'

DISABLE_CHECK_SECRET_SAVED_TO_VAULT = False
