# -*- coding: utf-8 -*-
from passport.backend.oauth.settings.common_settings.db import *
from passport.backend.oauth.settings.common_settings.db import _BASE_DB_CONFIG
from passport.backend.oauth.settings.tvm_settings import secrets
from passport.backend.oauth.settings.tvm_settings.env import (
    ENV_NAME,
    ENV_TYPE,
)


_BASE_MASTER_CONFIG = _BASE_DB_CONFIG.copy(
    type='master',
    user=secrets.DB_MASTER_USER,
    password=secrets.DB_MASTER_PASSWORD,
)
_BASE_SLAVE_CONFIG = _BASE_DB_CONFIG.copy(
    type='slave',
    user=secrets.DB_SLAVE_USER,
    password=secrets.DB_SLAVE_PASSWORD,
)

_MYSQL_CONFIG = {
    'intranet': {
        'development': frozendict(
            oauthdbcentral=frozendict(
                master=_BASE_MASTER_CONFIG.copy(
                    host='cnt-dbm-test.passport.yandex.net',
                    database='tvmdbcentral_yateam_testrc',
                ),
                slave=_BASE_SLAVE_CONFIG.copy(
                    host='cnt-dbs-test.passport.yandex.net',
                    database='tvmdbcentral_yateam_testrc',
                ),
            ),
        ),
        'testing': frozendict(
            oauthdbcentral=frozendict(
                master=_BASE_MASTER_CONFIG.copy(
                    host='cnt-dbm-test.passport.yandex.net',
                    database='tvmdbcentral_yateam',
                ),
                slave=_BASE_SLAVE_CONFIG.copy(
                    host='cnt-dbs-test.passport.yandex.net',
                    database='tvmdbcentral_yateam',
                ),
            ),
        ),
        'production': frozendict(
            oauthdbcentral=frozendict(
                master=_BASE_MASTER_CONFIG.copy(
                    host='yateam-dbm.passport.yandex.net',
                    database='tvmdbcentral',
                ),
                slave=_BASE_SLAVE_CONFIG.copy(
                    host='yateam-dbs.passport.yandex.net',
                    database='tvmdbcentral',
                ),
            ),
        ),
    },
    'localhost': {
        'testing': {},
        'production': {},
    },
    'stress': {
        'stress': {},
    },
}
_MYSQL_CONFIG['localhost']['development'] = _MYSQL_CONFIG['localhost']['testing']
_MYSQL_CONFIG['localhost']['rc'] = _MYSQL_CONFIG['localhost']['production']
_MYSQL_CONFIG['intranet']['rc'] = _MYSQL_CONFIG['intranet']['production']

MYSQL_CONFIG = _MYSQL_CONFIG[ENV_NAME][ENV_TYPE]
SHARD_NAMES = []
MYSQL_SHARDING_CONFIG = {}
MYSQL_SHARDING_RANGES = []
