# -*- coding: utf-8 -*-
from passport.backend.oauth.settings.common_settings.logs import *


LOG_PATH = '/var/log/yandex/tvm-api/'

LOGGING = make_logging_config(
    log_path=LOG_PATH,
    extra_formatters={
        'tvm_api_vault_client': {
            'format': '%(message)s\trequest_id=%(request_id)s',
        },
    },
    extra_handlers={
        'tvm_api_vault_client': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'tvm_api_vault_client.log',
            'formatter': 'tvm_api_vault_client',
            'filters': ['request_id'],
        },
        'tvm_secret_key_rotator': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'management/tvm_secret_key_rotator.log',
            'formatter': 'default',
        },
        'save_tvm_secrets_to_vault': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'management/save_tvm_secrets_to_vault.log',
            'formatter': 'default',
        },
        'update_tvm_secrets_roles': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'management/update_tvm_secrets_roles.log',
            'formatter': 'default',
        },
    },
    extra_loggers={
        'tvm_api.vault_client': {
            'handlers': ['tvm_api_vault_client'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'management.tvm_secret_key_rotator': {
            'handlers': ['tvm_secret_key_rotator', 'console'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'management.save_tvm_secrets_to_vault': {
            'handlers': ['save_tvm_secrets_to_vault', 'console'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'management.update_tvm_secrets_roles': {
            'handlers': ['update_tvm_secrets_roles', 'console'],
            'level': 'DEBUG',
            'propagate': False,
        },
    },
)
