# -*- coding: utf-8 -*-
# isort:skip_file
import os
from imp import load_source

secret_settings = None

for config_file in (
    '/usr/lib/yandex/tvm-secrets/local_settings.py',
    os.path.join(os.path.dirname(__file__), 'default.py'),
):
    try:
        secret_settings = load_source('secret_settings', config_file)
        break
    except IOError:
        pass


if not secret_settings:
    from passport.backend.oauth.settings.tvm_settings.secrets import default as secret_settings


# логин-пароль для ro-доступа к БД
DB_SLAVE_USER = secret_settings.DB_SLAVE_USER
DB_SLAVE_PASSWORD = secret_settings.DB_SLAVE_PASSWORD

# логин-пароль для rw-доступа к БД
DB_MASTER_USER = secret_settings.DB_MASTER_USER
DB_MASTER_PASSWORD = secret_settings.DB_MASTER_PASSWORD

# пользователь и ключ для доступа доступа к Секретнице
VAULT_USER_LOGIN = secret_settings.VAULT_USER_LOGIN
VAULT_USER_PRIVATE_KEY = secret_settings.VAULT_USER_PRIVATE_KEY
