# -*- coding: utf-8 -*-

from library.python.vault_client.instances import (
    VAULT_PRODUCTION_API,
    VAULT_TESTING_API,
)
from passport.backend.oauth.settings.tvm_settings import secrets
from passport.backend.oauth.settings.tvm_settings.env import (
    ENV_NAME,
    ENV_TYPE,
)


_VAULT_PRODUCTION_WEB = 'https://yav.yandex-team.ru'
_VAULT_TESTING_WEB = 'https://yav-test.yandex-team.ru'

_VAULT_URLS = {
    'intranet': {
        'production': {
            'api': VAULT_PRODUCTION_API,
            'web': _VAULT_PRODUCTION_WEB,
        },
        'rc': {
            'api': VAULT_PRODUCTION_API,
            'web': _VAULT_PRODUCTION_WEB,
        },
        'testing': {
            'api': VAULT_TESTING_API,
            'web': _VAULT_TESTING_WEB,
        },
        'development': {
            'api': VAULT_TESTING_API,
            'web': _VAULT_TESTING_WEB,
        },
    },
    'localhost': {
        'development': {
            'api': VAULT_TESTING_API,
            'web': _VAULT_TESTING_WEB,
        },
        'testing': {
            'api': '',
            'web': '',
        },
        'rc': {
            'api': '',
            'web': '',
        },
        'production': {
            'api': '',
            'web': '',
        },
    },
    'stress': {
        'stress': {
            'api': '',
            'web': '',
        },
    },
}

VAULT_API_URL = _VAULT_URLS[ENV_NAME][ENV_TYPE]['api']
VAULT_WEB_URL = _VAULT_URLS[ENV_NAME][ENV_TYPE]['web']

VAULT_USER_LOGIN = secrets.VAULT_USER_LOGIN
VAULT_USER_PRIVATE_KEY = secrets.VAULT_USER_PRIVATE_KEY

VAULT_SECRET_LINK_TEMPLATE = '%s/secret/{secret_uuid}/explore/version/{version_uuid}' % VAULT_WEB_URL

VAULT_SECRET_TVM_ROLES = [
    1,  # Руководитель сервиса
    630,  # TVM-менеджер
]

VAULT_SECRET_TAGS = 'tvm'  # Несколько тегов прописать через запятую
