DROP DATABASE IF EXISTS oauthdbcentral;

CREATE DATABASE oauthdbcentral CHARACTER SET latin1;

USE oauthdbcentral;

CREATE TABLE auto_id_client (
	id INTEGER NOT NULL AUTO_INCREMENT,
	PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE auto_id_request (
	id BIGINT NOT NULL AUTO_INCREMENT,
	PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE auto_id_token (
	id BIGINT NOT NULL AUTO_INCREMENT,
	PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE auto_id_tvm_client (
	id INTEGER NOT NULL AUTO_INCREMENT,
	PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE auto_id_tvm_secret_key (
	id INTEGER NOT NULL AUTO_INCREMENT,
	PRIMARY KEY (id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE client_attributes (
	id INTEGER NOT NULL,
	type SMALLINT NOT NULL,
	value VARBINARY(65523) NOT NULL,
	PRIMARY KEY (id, type)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE client_by_display_id (
	display_id VARBINARY(50) NOT NULL,
	id INTEGER NOT NULL,
	PRIMARY KEY (display_id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE client_by_owner (
	owner_groups VARBINARY(2000),
	owner_uids VARBINARY(2000),
	uids VARCHAR(60000),
	modified_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	id INTEGER NOT NULL,
	UNIQUE (id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE INDEX ix_client_by_owner_owner_groups ON client_by_owner (owner_groups);

CREATE INDEX ix_client_by_owner_owner_uids ON client_by_owner (owner_uids);

CREATE INDEX ix_client_by_owner_uids ON client_by_owner (uids);

CREATE TABLE client_by_params (
	uid BIGINT NOT NULL,
	display_id VARBINARY(50) NOT NULL,
	approval_status INTEGER NOT NULL,
	services VARCHAR(700) NOT NULL,
	is_yandex BOOL NOT NULL,
	id INTEGER NOT NULL,
	CHECK (is_yandex IN (0, 1)),
	UNIQUE (id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE INDEX ix_client_by_params_approval_status ON client_by_params (approval_status);

CREATE INDEX ix_client_by_params_display_id ON client_by_params (display_id);

CREATE INDEX ix_client_by_params_is_yandex ON client_by_params (is_yandex);

CREATE TABLE client_by_uid (
	uid BIGINT NOT NULL,
	id INTEGER NOT NULL,
	UNIQUE (id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE INDEX ix_client_by_uid_uid ON client_by_uid (uid);

CREATE TABLE request_attributes (
	id BIGINT NOT NULL,
	type SMALLINT NOT NULL,
	value VARBINARY(65523) NOT NULL,
	PRIMARY KEY (id, type)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE request_by_code (
	code VARBINARY(50) NOT NULL,
	client_id BIGINT NOT NULL,
	id BIGINT NOT NULL,
	PRIMARY KEY (code, client_id),
	UNIQUE (id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE request_by_display_id (
	display_id VARBINARY(100) NOT NULL,
	id BIGINT NOT NULL,
	PRIMARY KEY (display_id),
	UNIQUE (id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE request_by_unique_code (
	unique_code VARBINARY(50) NOT NULL,
	id BIGINT NOT NULL,
	PRIMARY KEY (unique_code),
	UNIQUE (id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE tvm_client_attributes (
	id INTEGER NOT NULL,
	type SMALLINT NOT NULL,
	value VARBINARY(65523) NOT NULL,
	PRIMARY KEY (id, type)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE tvm_client_by_abc_request_id (
	abc_request_id BIGINT,
	id INTEGER NOT NULL,
	UNIQUE (abc_request_id),
	UNIQUE (id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE tvm_client_by_creator_uid (
	creator_uid BIGINT NOT NULL,
	id INTEGER NOT NULL,
	UNIQUE (id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE INDEX ix_tvm_client_by_creator_uid_creator_uid ON tvm_client_by_creator_uid (creator_uid);

CREATE TABLE tvm_secret_key_attributes (
	id INTEGER NOT NULL,
	type SMALLINT NOT NULL,
	value VARBINARY(65523) NOT NULL,
	PRIMARY KEY (id, type)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

