DROP DATABASE IF EXISTS oauthdbshard1;

CREATE DATABASE oauthdbshard1 CHARACTER SET latin1;

USE oauthdbshard1;

CREATE TABLE token_attributes (
	id BIGINT NOT NULL,
	type SMALLINT NOT NULL,
	value VARBINARY(65523) NOT NULL,
	PRIMARY KEY (id, type)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE token_by_access_token (
	access_token VARBINARY(100) NOT NULL,
	id BIGINT NOT NULL,
	PRIMARY KEY (access_token)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE token_by_alias (
	uid BIGINT NOT NULL,
	alias VARBINARY(50) NOT NULL,
	id BIGINT NOT NULL,
	PRIMARY KEY (uid, alias)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE token_by_params (
	uid BIGINT NOT NULL,
	client_id INTEGER NOT NULL,
	scope_ids VARCHAR(600) NOT NULL,
	device_id VARBINARY(50) NOT NULL,
	id BIGINT NOT NULL,
	PRIMARY KEY (uid, client_id, scope_ids, device_id)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE INDEX ix_token_by_params_uid ON token_by_params (uid);

