# -*- coding: utf-8 -*-
# isort:skip_file
import os

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'passport.backend.oauth.tvm_api.settings.default_settings')

from django.core.wsgi import get_wsgi_application
from django.conf import settings
from passport.backend.library.configurator import Configurator
from passport.backend.library.wsgi_runner import Runner
from passport.backend.oauth.core.api.startup import (
    configure_db_connections,
    prepare_environment,
)
import yenv


def post_worker_init(_worker):
    configure_db_connections()


def main():
    prepare_environment(skip_db=True, skip_geodata=True)  # БД проинициализируем после форка
    application = get_wsgi_application()
    config = Configurator(
        'oauth/tvm-api',
        configs=[
            'base.yaml',
            '%s.yaml' % yenv.type,
            'devserver.yaml' if settings.DEBUG else {},
            'gunicorn-custom.yaml?',  # отсутствует в ресурсах, но может читаться с диска
        ],
    )
    runner = Runner(
        application,
        config=config,
    )
    runner.run()
