# -*- coding: utf-8 -*-
from passport.backend.oauth.core.db.eav.attributes import (
    CollectionAttribute,
    DatetimeAttribute,
    EncryptedStringAttribute,
    IntegerAttribute,
    register_attribute_types,
    StringAttribute,
)
from passport.backend.oauth.core.db.eav.schemas import (
    auto_id_columns,
    central_metadata,
    eav_columns,
    register_auto_id,
)
from sqlalchemy.schema import (
    Column,
    Table,
)
from sqlalchemy.types import (
    BigInteger,
    Integer,
)


# Типы атрибутов для TVM-моделей
# Закомментированные более не использутся
register_attribute_types(
    'tvm_client',
    {
        1: StringAttribute('name'),
        2: IntegerAttribute('creator_uid'),
        # 3: CollectionAttribute('allowed_uids', int),
        # 4: StringAttribute('env_type'),
        5: EncryptedStringAttribute('client_secret'),
        6: CollectionAttribute('secret_key_ids', int),
        # 7: CollectionAttribute('allowed_grant_types', str),
        # 8: BooleanAttribute('is_symmetric'),  # есть только ассимметричные
        # 9: IntegerAttribute('token_ttl'),
        10: DatetimeAttribute('created'),
        11: DatetimeAttribute('modified'),
        # 12: IntegerAttribute('signature_type', default_value=0),
        # 13: StringAttribute('payload'),
        # 14: IntegerAttribute('default_secret_key_id'),
        # 15: CollectionAttribute('owner_uids', int),
        # 16: CollectionAttribute('owner_groups', str),
        # 17: CollectionAttribute('owner_group_uids', int),
        18: DatetimeAttribute('deleted'),
        19: EncryptedStringAttribute('old_client_secret'),
        20: IntegerAttribute('abc_request_id'),
        21: IntegerAttribute('abc_service_id'),
        22: StringAttribute('vault_secret_uuid'),
        23: StringAttribute('vault_version_uuid'),
    },
)
register_attribute_types(
    'tvm_secret_key',
    {
        1: EncryptedStringAttribute('public_secret'),
        2: EncryptedStringAttribute('private_secret'),
        3: DatetimeAttribute('created'),
        4: DatetimeAttribute('deleted'),
    },
)

# ID для сущностей TVM

register_auto_id('tvm_client', Table('auto_id_tvm_client', central_metadata, *auto_id_columns()))
register_auto_id('tvm_secret_key', Table('auto_id_tvm_secret_key', central_metadata, *auto_id_columns()))


# Приложения для TVM

tvm_client_attributes_table = Table('tvm_client_attributes', central_metadata, *eav_columns(id_type=Integer))

# индекс по уиду - для списка зареганных приложений
tvm_client_by_creator_uid_table = Table(
    'tvm_client_by_creator_uid',
    central_metadata,
    Column('creator_uid', BigInteger, index=True, nullable=False),
    Column('id', Integer, unique=True, nullable=False),
)

tvm_client_by_abc_request_id_table = Table(
    'tvm_client_by_abc_request_id',
    central_metadata,
    Column('abc_request_id', BigInteger, nullable=True, unique=True),
    Column('id', Integer, unique=True, nullable=False),
)

tvm_secret_key_attributes_table = Table('tvm_secret_key_attributes', central_metadata, *eav_columns(id_type=Integer))
