# -*- coding: utf-8 -*-
import logging

from passport.backend.oauth.core.common.utils import now
from passport.backend.oauth.core.db.eav import (
    EavAttr,
    EavModel,
)
from passport.backend.oauth.core.db.mixins.deletion_mixin import DeletionMixin
from passport.backend.oauth.tvm_api.tvm_api.db.errors import TVMSecretKeyGenerationError
from passport.backend.oauth.tvm_api.tvm_api.db.schemas import tvm_secret_key_attributes_table
from passport.backend.oauth.tvm_api.tvm_keygen import generate_rw_keys


log = logging.getLogger('db.tvm_secret_key')


MAX_ERROR_OUTPUT_SIZE = 100


def generate_asymmetric_keys():
    try:
        return generate_rw_keys()
    # Ошибки не маскируем, в лог они запишутся как unhandled exception
    except RuntimeError as e:
        raise TVMSecretKeyGenerationError('%s %s' % (e.__class__.__name__, e))


class TVMSecretKey(EavModel, DeletionMixin):
    _entity_name = 'tvm_secret_key'
    _table = tvm_secret_key_attributes_table

    public_secret = EavAttr()
    private_secret = EavAttr()
    created = EavAttr()

    @classmethod
    def create(cls):
        obj = cls(created=now())
        obj.public_secret, obj.private_secret = generate_asymmetric_keys()
        return obj
