# -*- coding: utf-8 -*-
from django.conf import settings
from passport.backend.utils.time import datetime_to_integer_unixtime


def client_to_response(client):
    data = {
        'id': client.id,
        'name': client.name,
        'create_time': datetime_to_integer_unixtime(client.created),
        'modification_time': datetime_to_integer_unixtime(client.modified),
        'creator_uid': client.creator_uid,
        'abc_service_id': client.abc_service_id,
    }
    if client.is_deleted:
        data.update(deletion_time=datetime_to_integer_unixtime(client.deleted))
    if client.is_secret_saved_to_vault():
        data.update(
            vault_link=settings.VAULT_SECRET_LINK_TEMPLATE.format(
                secret_uuid=client.vault_secret_uuid,
                version_uuid=client.vault_version_uuid,
            ),
        )
    return data
