# -*- coding: utf-8 -*-
from passport.backend.oauth.core.api.base import BaseApiView
from passport.backend.oauth.core.api.errors import ClientNotFoundError
from passport.backend.oauth.core.db.eav import EntityNotFoundError
from passport.backend.oauth.tvm_api.tvm_api.db.tvm_client import TVMClient
from passport.backend.oauth.tvm_api.tvm_api.tvm.forms import ClientForm
from passport.backend.oauth.tvm_api.tvm_api.tvm.utils import client_to_response


class ClientInfoView(BaseApiView):
    required_grants = []
    allowed_methods = ['GET']
    base_form = ClientForm
    ensure_ascii_response = False

    def __init__(self):
        super(ClientInfoView, self).__init__()
        self.client = None

    def get_client(self, allow_deleted=False):
        try:
            self.client = TVMClient.by_id(self.form_values['client_id'], allow_deleted=allow_deleted)
        except EntityNotFoundError:
            raise ClientNotFoundError()

    def process_request(self, request):
        self.get_client(allow_deleted=self.form_values['with_deleted'])
        self.response_values.update(
            **client_to_response(self.client)
        )
