# -*- coding: utf-8 -*-
from passport.backend.oauth.core.api.errors import BaseApiError


class AbcTeamMemberRequiredError(BaseApiError):
    """Операцию может выполнять только член команды, наделённый определёнными ролями"""
    errors = ['abc_team.member_required']


class OldSecretExistsError(BaseApiError):
    """У приложения уже есть old_secret"""
    errors = ['old_secret.exists']


class OldSecretNotFoundError(BaseApiError):
    """У приложения отсутствует old_secret"""
    errors = ['old_secret.not_found']


class HaveNotPutSecretToVaultError(BaseApiError):
    """Еще не успели записать значение секрета в Секретницу. Операции с секретами запрещены"""
    errors = ['secret.not_put_to_vault']


__all__ = (
    'AbcTeamMemberRequiredError',
    'HaveNotPutSecretToVaultError',
    'OldSecretExistsError',
    'OldSecretNotFoundError',
)
