# -*- coding: utf-8 -*-
from django import forms
from passport.backend.oauth.core.api.forms import (
    error_messages,
    IntegerField,
    StrippedCharField,
    UidField,
    UidMixin,
    UidOptionalMixin,
)
from passport.backend.oauth.tvm_api.tvm_api.mixins import ClientIdMixin


class ClientForm(ClientIdMixin, UidOptionalMixin):
    pass


class PaginationForm(forms.Form):
    page = IntegerField(required=False, min_value=1, default=1, error_messages=error_messages)
    page_size = IntegerField(required=False, min_value=1, max_value=100, default=50, error_messages=error_messages)


class CreateClientForm(forms.Form):
    name = StrippedCharField(required=True, error_messages=error_messages)
    abc_service_id = IntegerField(required=True, min_value=1, error_messages=error_messages)
    abc_request_id = IntegerField(required=True, min_value=1, error_messages=error_messages)


class CreateClientV1Form(CreateClientForm, UidMixin):
    pass


class EditClientForm(ClientIdMixin):
    name = StrippedCharField(required=True, error_messages=error_messages)


class EditClientV1Form(EditClientForm, UidMixin):
    pass


class ChangeClientAbcServiceForm(ClientIdMixin):
    initiator_uid = UidField(error_messages=error_messages)
    abc_service_id = IntegerField(required=True, min_value=1, error_messages=error_messages)
