# -*- coding: utf-8 -*-
from django.urls import path
from passport.backend.oauth.tvm_api.tvm_api.tvm_abc import views


urlpatterns = [
    path('1/clients', views.ListClientsView.as_view(), name='tvm_abc_list_clients'),
    path('1/client/info', views.ClientInfoV1View.as_view(), name='tvm_abc_client_info_v1'),
    path('2/client/info', views.ClientInfoView.as_view(), name='tvm_abc_client_info'),
    path('1/client/create', views.CreateClientV1View.as_view(), name='tvm_abc_create_client_v1'),
    path('2/client/create', views.CreateClientView.as_view(), name='tvm_abc_create_client'),
    path('1/client/edit', views.EditClientV1View.as_view(), name='tvm_abc_edit_client_v1'),
    path('2/client/edit', views.EditClientView.as_view(), name='tvm_abc_edit_client'),
    path('1/client/delete', views.DeleteClientV1View.as_view(), name='tvm_abc_delete_client_v1'),
    path('2/client/delete', views.DeleteClientView.as_view(), name='tvm_abc_delete_client'),
    path('1/client/change_abc_service', views.ChangeClientAbcServiceView.as_view(), name='tvm_abc_change_client_abc_service'),
    path('1/client/secret/recreate', views.RecreateClientSecretV1View.as_view(), name='tvm_abc_recreate_client_secret_v1'),
    path('2/client/secret/recreate', views.RecreateClientSecretView.as_view(), name='tvm_abc_recreate_client_secret'),
    path('1/client/secret/restore_old', views.RestoreClientSecretV1View.as_view(), name='tvm_abc_restore_old_client_secret_v1'),
    path('2/client/secret/restore_old', views.RestoreClientSecretView.as_view(), name='tvm_abc_restore_old_client_secret'),
    path('1/client/secret/delete_old', views.DeleteOldClientSecretV1View.as_view(), name='tvm_abc_delete_old_client_secret_v1'),
    path('2/client/secret/delete_old', views.DeleteOldClientSecretView.as_view(), name='tvm_abc_delete_old_client_secret'),
    path('1/client/secret/save', views.SaveSecretToVaultV1View.as_view(), name='tvm_abc_save_secret_to_vault_v1'),
    path('2/client/secret/save', views.SaveSecretToVaultView.as_view(), name='tvm_abc_save_secret_to_vault'),
]
